﻿using System;
using System.Data;
using System.Web.UI;
using Microsoft.SharePoint;
using Microsoft.SharePoint.WebControls;

namespace Contoso.ContosoWebPart
{
   public partial class ContosoWebPartUserControl : UserControl
   {
      protected void Page_Load(object sender, EventArgs e)
      {
         SPWeb web = SPContext.Current.Web;
         SPList list = web.Lists.TryGetList("Kunde");
         if (!Page.IsPostBack)
         {
            BindToGrid(list, gridViewCustomers);
         }
      }

      private void BindToGrid(SPList myList, SPGridView gridView)
      {
         SPListItemCollection results = myList.Items;

         DataTable table;
         table = new DataTable();
         table.Columns.Add("Company", typeof(string));
         table.Columns.Add("Title", typeof(string));
         table.Columns.Add("FirstName", typeof(string));
         // Create rows for each splistitem
         DataRow row;
         foreach (SPListItem result in results)
         {
            row = table.Rows.Add();
            row["Company"] = result["Company"].ToString();
            row["Title"] = result["Name"].ToString();
            row["FirstName"] = result["FirstName"] != null ?
                result["FirstName"].ToString() : String.Empty;
         }

         SPBoundField boundField;
         boundField = new SPBoundField();
         boundField.HeaderText = "Firma";
         boundField.DataField = "Company";
         gridView.Columns.Add(boundField);

         boundField = new SPBoundField();
         boundField.HeaderText = "Name";
         boundField.DataField = "Title";
         gridView.Columns.Add(boundField);

         boundField = new SPBoundField();
         boundField.HeaderText = "Vorname";
         boundField.DataField = "FirstName";
         gridView.Columns.Add(boundField);

         gridView.DataSource = table.DefaultView;
         gridView.DataBind();
      }
   }
}